package furny.ga.test;

import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.GA;
import ga.core.individual.population.KMeansClusterPopulation;
import ga.core.validation.GAContext;

public class TestClustering {

  public static void main(final String[] args) {
    final KMeansClusterPopulation<FurnLayoutIndividual> pop = new KMeansClusterPopulation<FurnLayoutIndividual>(
        null, 10, 3);

    final GAContext context = new GAContext();
    context.put(GA.KEY_VALIDATION_SPACE, new PseudoSpace(10f, 10f));

    final FurnLayoutIndividual ind1 = FurnLayoutIOUtil
        .parseIndividual("{(380,114,-18,3),(388,-67,-94,0)}");
    ind1.setContext(context);
    final FurnLayoutIndividual ind2 = FurnLayoutIOUtil
        .parseIndividual("{(388,-67,-94,0),(387,114,-18,3)}");
    ind2.setContext(context);
    final FurnLayoutIndividual ind3 = FurnLayoutIOUtil
        .parseIndividual("{(380,-67,-94,0),(438,114,-18,3)}");
    ind3.setContext(context);
    final FurnLayoutIndividual ind4 = FurnLayoutIOUtil
        .parseIndividual("{(380,-67,-94,0),(380,50,5,1),(380,114,-18,3)}");
    ind4.setContext(context);
    final FurnLayoutIndividual ind5 = FurnLayoutIOUtil
        .parseIndividual("{(388,114,-18,3)}");
    ind5.setContext(context);
    final FurnLayoutIndividual ind6 = FurnLayoutIOUtil
        .parseIndividual("{(388,0,0,0)}");
    ind6.setContext(context);
    final FurnLayoutIndividual ind7 = FurnLayoutIOUtil
        .parseIndividual("{(380,-100,100,0),(388,-50,-100,0),(387,200,-150,0)}");
    ind7.setContext(context);

    pop.addIndividual(ind1);
    pop.addIndividual(ind1);
    pop.addIndividual(ind2);
    pop.addIndividual(ind3);
    pop.addIndividual(ind4);
    pop.addIndividual(ind5);
    pop.addIndividual(ind6);
    pop.addIndividual(ind7);

    pop.doClustering();
    System.err.println();
    System.err.println(pop.toClusterString());

    ind1.setFitness(5);
    ind2.setFitness(5);
    ind3.setFitness(5);
    pop.assignFitness();

    System.err.println();
    System.err.println(pop.toClusterString());

    System.err.println(ind2.getFitnessWidth());

  }

}
